/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.sonarlint.eclipse.core.internal.builder.SonarLintBuilder;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;

public class IssuesUpdater
implements IPartListener2 {
    public void partOpened(IWorkbenchPartReference partRef) {
        IEditorInput input;
        IWorkbenchPart part = partRef.getPart(true);
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)input).getFile();
            IssuesUpdater.scheduleUpdate((IResource)resource);
        }
    }

    private static void scheduleUpdate(IResource resource) {
        IFile file = (IFile)resource.getAdapter(IFile.class);
        if (file != null) {
            SonarLintProject sonarProject = SonarLintProject.getInstance((IResource)file.getProject());
            if (!sonarProject.isAutoEnabled() || !SonarLintBuilder.shouldAnalyze(null, (IResource)file)) {
                return;
            }
            AnalyzeProjectRequest request = new AnalyzeProjectRequest(resource.getProject(), Arrays.asList(file));
            new AnalyzeProjectJob(request).schedule();
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }
}

